<!--Copyright 2023 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.

⚠️ Note that this file is in Markdown but contain specific syntax for our doc-builder (similar to MDX) that may not be
rendered properly in your Markdown viewer.

-->

# Llama-Adapter

[Llama-Adapter](https://hf.co/papers/2303.16199) is a PEFT method specifically designed for turning Llama into an
instruction-following model. The Llama model is frozen and only a set of adaptation prompts prefixed to the input
instruction tokens are learned. Since randomly initialized modules inserted into the model can cause the model to lose
some of its existing knowledge, Llama-Adapter uses zero-initialized attention with zero gating to progressively add the
instructional prompts to the model.

The abstract from the paper is:

*We present LLaMA-Adapter, a lightweight adaption method to efficiently fine-tune LLaMA into an instruction-following
model. Using 52K self-instruct demonstrations, LLaMA-Adapter only introduces 1.2M learnable parameters upon the frozen
LLaMA 7B model, and costs less than one hour for fine-tuning on 8 A100 GPUs. Specifically, we adopt a set of learnable
adaption prompts, and prepend them to the input text tokens at higher transformer layers. Then, a zero-init attention
mechanism with zero gating is proposed, which adaptively injects the new instructional cues into LLaMA, while
effectively preserves its pre-trained knowledge. With efficient training, LLaMA-Adapter generates high-quality
responses, comparable to Alpaca with fully fine-tuned 7B parameters. Furthermore, our approach can be simply extended to
multi-modal input, e.g., images, for image-conditioned LLaMA, which achieves superior reasoning capacity on ScienceQA.
We release our code at https://github.com/ZrrSkywalker/LLaMA-Adapter*.

## AdaptionPromptConfig

[[autodoc]] tuners.adaption_prompt.config.AdaptionPromptConfig

## AdaptionPromptModel

[[autodoc]] tuners.adaption_prompt.model.AdaptionPromptModel